IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_ingresos_por_fpago') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_ingresos_por_fpago
END
GO
CREATE PROCEDURE [dbo].[CP_ingresos_por_fpago]
	@pFecha_Desde			DATETIME,
	@pFecha_Hasta			DATETIME, 
	@pId_Sucursal           Smallint,
	@pIncluir_Seg           INT,
	@pId_Periodo_Caja       INT

AS

SET NOCOUNT ON
DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Descripcion	    CHAR(50)
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Tipo_Val   	CHAR(3)
		,@CursorOpen        INT
		,@Tipo	            char(1)
		,@Periodo           DATE 
		,@Id_sucursal	    SMALLINT
		,@Existe      	    SMALLINT
		,@Id_Tarjeta        char(10)
		,@Id_Tipo_Cbte      char(4)

CREATE TABLE #VTAS_FPAGO (
        Id_Tipo_Cbte char(4),
		Descripcion  Char(50),
        Efectivo	decimal(16,2),
		Depositos   decimal(16,2),
		Cheques     decimal(16,2),
		TarjCred    decimal(16,2),
		TarjDeb	    decimal(16,2),        
		Financiera  decimal(16,2),
		Ajuste      decimal(16,2),
		Total       decimal(16,2)
		)

    SELECT * INTO #UN FROM Empresas_Unid_Negocios  
    
    SELECT * INTO #CAJAS FROM Cajas_Periodos
	IF @pId_Periodo_Caja  <> 0
	   DELETE #CAJAS WHERE Id_Periodo_Caja <> @pId_Periodo_Caja    


	SELECT * INTO #SUCU FROM Empresas_Suc where Activo = 1
	IF @pId_Sucursal  <> 0
	   DELETE #SUCU WHERE ID_SUCURSAL <> @pId_Sucursal


    BEGIN
--vtas de contado 
    DECLARE TagCbtesCursor CURSOR FOR 
		select t.id_tipo_cbte,t.descripcion,v.id_tipo_val,tc.tipo,isnull(v.id_tarjeta,''),sum(Isnull(v.importe,0) * t.Compromete_Factura*v.cotizacion) as importe
		from cbtes c, valores v LEFT OUTER JOIN Valores_Tarjetas_Cred tc on v.id_tarjeta = tc.id_tarjeta 
		,valores_mov m, cbtes_tipos t, #UN U, #CAJAS CA
		where c.id_trans = m.id_trans 
		and m.id_valor = v.id_valor 
		and m.renglon_nro  = 1
		AND V.Id_Periodo_Caja = CA.Id_Periodo_Caja
		and c.id_tipo_cbte = t.id_tipo_cbte
		AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		and t.Compromete_Factura in (1,-1)
		and c.id_cond_pago = 1
		AND C.FECHA >= @pFecha_Desde 
		AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)
		and c.Id_Estado_Cbte not in (0,3)
		group by t.id_tipo_cbte,t.descripcion,v.id_tipo_val,tc.tipo,v.id_tarjeta
 

	OPEN TagCbtesCursor

	FETCH NEXT FROM TagCbtesCursor INTO @Id_tipo_cbte,@Descripcion,@id_tipo_val,@tipo,@id_tarjeta,@Importe 
	SET @CursorOpen = 0	
	SET @UltError = 0
	WHILE @@FETCH_STATUS=0 AND @UltError  = 0
	BEGIN
            SET @Existe = (Select ISNULL(Count(*),0) from #VTAS_FPAGO where Id_Tipo_Cbte = @Id_Tipo_Cbte)
			
			IF @Existe = 0
			   INSERT INTO #VTAS_FPAGO (
			            Id_Tipo_Cbte ,
						Descripcion ,
						Efectivo	,
						Depositos	,
						Cheques     ,
						TarjCred    ,
						TarjDeb	    ,        
						Financiera  ,
						Ajuste,
						Total  
						)
				VALUES (
				@Id_Tipo_Cbte,
                @Descripcion,
			    0,
			    0,
				0,
				0,
			    0,
				0,
				0,
				0
				)

			IF @id_tipo_val = 'EFE'                  UPDATE #VTAS_FPAGO SET  Efectivo = Efectivo + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'CH3'                  UPDATE #VTAS_FPAGO SET  Cheques = Cheques + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'TAR' AND @TIPO = 'C'  UPDATE #VTAS_FPAGO SET  TarjCred = TarjCred + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'TAR' AND @TIPO = 'D'  UPDATE #VTAS_FPAGO SET  TarjDeb = TarjDeb + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'FIN'                  UPDATE #VTAS_FPAGO SET  Financiera = Financiera + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'DB'                   UPDATE #VTAS_FPAGO SET  Depositos = Depositos + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'AJU'                  UPDATE #VTAS_FPAGO SET  Ajuste = Ajuste + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte


   		FETCH NEXT FROM TagCbtesCursor INTO @Id_Tipo_Cbte,@Descripcion,@id_tipo_val,@tipo,@id_tarjeta,@Importe 

	END
	CLOSE TagCbtesCursor
	DEALLOCATE TagCbtesCursor
 --recibos
    DECLARE TagCbtesCursor2 CURSOR FOR 
		select t.Id_Tipo_Cbte,t.descripcion,v.id_tipo_val,tc.tipo,isnull(v.id_tarjeta,''),sum(Isnull(v.importe,0)*v.cotizacion) as importe
		from cbtes c, valores v LEFT OUTER JOIN Valores_Tarjetas_Cred tc on v.id_tarjeta = tc.id_tarjeta 
		,valores_mov m, cbtes_tipos t, #UN U, #CAJAS CA
		where c.id_trans = m.id_trans 
		and m.id_valor = v.id_valor 
		and m.renglon_nro  = 1
		AND V.Id_Periodo_Caja = CA.Id_Periodo_Caja
		and c.id_tipo_cbte = t.id_tipo_cbte
		AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		and t.Compromete_Recibos in (1,-1)
		AND C.FECHA >= @pFecha_Desde 
		AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)
		and c.Id_Estado_Cbte not in (0,3)
		group by t.Id_Tipo_Cbte,t.descripcion,v.id_tipo_val,tc.tipo,v.id_tarjeta
 

	OPEN TagCbtesCursor2

	FETCH NEXT FROM TagCbtesCursor2 INTO @Id_Tipo_Cbte,@Descripcion,@id_tipo_val,@tipo,@id_tarjeta,@Importe 
	SET @CursorOpen = 0	
	SET @UltError = 0
	WHILE @@FETCH_STATUS=0 AND @UltError  = 0
	BEGIN
            SET @Existe = (Select ISNULL(Count(*),0) from #VTAS_FPAGO where Id_Tipo_Cbte = @Id_Tipo_Cbte)
			
			IF @Existe = 0
			   INSERT INTO #VTAS_FPAGO (
			            Id_Tipo_Cbte ,
						Descripcion ,
						Efectivo	,
						Depositos	,
						Cheques     ,
						TarjCred    ,
						TarjDeb	    ,        
						Financiera  ,
						Ajuste,
						Total  
						)
				VALUES (
				@Id_Tipo_Cbte,
                @Descripcion,
			    0,
			    0,
				0,
			    0,
				0,
				0,
				0,
				0
				)

			IF @id_tipo_val = 'EFE'                  UPDATE #VTAS_FPAGO SET  Efectivo = Efectivo + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'CH3'                  UPDATE #VTAS_FPAGO SET  Cheques = Cheques + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'TAR' AND @TIPO = 'C'  UPDATE #VTAS_FPAGO SET  TarjCred = TarjCred + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte 
			IF @id_tipo_val = 'TAR' AND @TIPO = 'D'  UPDATE #VTAS_FPAGO SET  TarjDeb = TarjDeb + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte 
			IF @id_tipo_val = 'FIN'                  UPDATE #VTAS_FPAGO SET  Financiera = Financiera + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'DB'                   UPDATE #VTAS_FPAGO SET  Depositos = Depositos + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte
			IF @id_tipo_val = 'AJU'                  UPDATE #VTAS_FPAGO SET  Ajuste = Ajuste + @Importe WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte


   		FETCH NEXT FROM TagCbtesCursor2 INTO @Id_Tipo_Cbte,@Descripcion,@id_tipo_val,@tipo,@id_tarjeta,@Importe 

	END
	CLOSE TagCbtesCursor2
	DEALLOCATE TagCbtesCursor2

----fin
        UPDATE #VTAS_FPAGO SET  Total = Efectivo+Depositos+TarjCred+TarjDeb+Financiera+Ajuste+Cheques


		SELECT * FROM #VTAS_FPAGO  where Total <> 0 ORDER BY 1

 END

 DROP TABLE #VTAS_FPAGO
 DROP TABLE #UN
 DROP TABLE #SUCU
 DROP TABLE #CAJAS

-- DROP TABLE #REC
-- DROP TABLE #REC2




 -- EXEC CP_ingresos_por_fpago '20220101','20230516',0,''
